## Multimodal analysis of ALS data
# © Regents of the University of Minnesota.
# This software is licensed under The MIT License.
# This code is derived based on the MRtrix tutorial and instructions provided at https://mrtrix.readthedocs.io/en/0.3.16/workflows/fixel_based_analysis.html
# How to cite: If you use this software for your work, please cite original MRtrix Fixel Based Analysis references and our paper Pisharady, P.K., Eberly, L.E. et al., Improved Diagnostic Accuracy and Sensitivity to Longitudinal Change in ALS with Multimodal MRI of the Brain and Cervical Cord

# List all baseline (first 11) and followup data (last 11) of ALS participants
declare -a arr1=("SUBJ001" "SUBJ002" "SUBJ003" "SUBJ004" "SUBJ005" "SUBJ006" "SUBJ007" "SUBJ008" "SUBJ009" "SUBJ010" "SUBJ011" "SUBJ001_3" "SUBJ002_3" "SUBJ003_3" "SUBJ004_3" "SUBJ005_3" "SUBJ006_3" "SUBJ007_3" "SUBJ008_3" "SUBJ009_3" "SUBJ010_3" "SUBJ011_3")

# Use only baseline data for creating the fod template
declare -a arr2=("SUBJ001" "SUBJ002" "SUBJ003" "SUBJ004" "SUBJ005" "SUBJ006" "SUBJ007" "SUBJ008" "SUBJ009" "SUBJ010" "SUBJ011")

#cd to the subject folders with the data and the masks
# you can point to the folders where you did dtifit/ bedpostx, or you can copy data, masks, bevecs, and bvals to a new location only for the mrtrix analysis
# rename data folder and maksnames here as necessary
cd /home/Data/ALS/mrtrix_long2
mkdir template
cd template
mkdir fod_input
mkdir mask_input

# Calculate response functions
for ((i=0;i<${#arr1[@]};++i));
do
echo "------- Processing: ${arr1[i]} ---------"
#cd to the subject folders with the data and the masks
cd /home/Data/ALS/mrtrix_long2/"${arr1[i]}"
dwibiascorrect data.nii.gz data_unbiased.nii.gz -ants -fslgrad bvecs bvals -nthreads 32 -force
dwi2response dhollander -fslgrad bvecs bvals data_unbiased.nii.gz response_wm.txt response_gm.txt response_csf.txt -nthreads 32 -force
done

#calculate group average response
cd /home/Data/ALS/mrtrix_long2/
average_response */response_wm.txt group_average_response_wm.txt
average_response */response_gm.txt group_average_response_gm.txt
average_response */response_csf.txt group_average_response_csf.txt

# Resize masks
for ((i=0;i<${#arr1[@]};++i));
do
echo "------- Processing: ${arr1[i]} ---------"
#cd to the subject folders with the data and the masks
cd /home/Data/ALS/mrtrix_long2/"${arr1[i]}"
mrresize "${arr1[i]}"_mask.nii.gz -voxel 1.00 "${arr1[i]}"_mask_upsampled.nii.gz -force
fslmaths "${arr1[i]}"_mask_upsampled.nii.gz -thr 0.01 "${arr1[i]}"_mask_upsampled_thr.nii.gz
fslmaths "${arr1[i]}"_mask_upsampled_thr.nii.gz -bin "${arr1[i]}"_mask_upsampled_bin.nii.gz
done

# FOD calculations
for ((i=0;i<${#arr1[@]};++i));
do
echo "------- Processing: ${arr1[i]} ---------"
#cd to the subject folders with the data and the masks
cd /home/Data/ALS/mrtrix_long2/"${arr1[i]}"
mrresize data_unbiased.nii.gz -voxel 1.0 data_upsampled.nii.gz -force #
mrconvert data_upsampled.nii.gz dwi.mif -fslgrad bvecs bvals -nthreads 32 -force
mrconvert mask_upsampled_bin.nii.gz mask_upsampled.mif -nthreads 32 -force
dwi2fod msmt_csd dwi.mif ../group_average_response_wm.txt wmfod.mif ../group_average_response_csf.txt csf.mif -mask mask_upsampled.mif -nthreads 32 -force
mtnormalise wmfod.mif wmfod_norm.mif csf.mif csf_norm.mif -mask mask_upsampled.mif -nthreads 32 -force
done

for ((i=0;i<${#arr2[@]};++i));
do
echo "------- Processing: ${arr2[i]} ---------"
cp -r /home/Data/ALS/mrtrix_long2/"${arr2[i]}"/wmfod_norm.mif /home/Data/ALS/mrtrix_long2/template/fod_input/"${arr2[i]}"_fod.mif
cp -r /home/Data/ALS/mrtrix_long2/"${arr2[i]}"/mask_upsampled.mif /home/Data/ALS/mrtrix_long2/template/mask_input/"${arr2[i]}"_mask.mif
done

# --------------------------------------- population template -----------------------------
# Run upto this population template step first, continue with the rest after the template is created, which will take some time. Otherwise the steps below that this will give an error.
cd /home/Data/ALS/mrtrix_long2/
population_template template/fod_input -mask_dir template/mask_input template/wmfod_template.mif -nthreads 32 -force -voxel_size 1.0

for ((i=0;i<${#arr1[@]};++i));
do
echo "------- Processing: ${arr1[i]} ---------"
cd /home/Data/ALS/mrtrix_long2/"${arr1[i]}"
mrregister wmfod_norm.mif -mask1 mask_upsampled.mif ../template/wmfod_template.mif -nl_warp subject2template_warp.mif template2subject_warp.mif -nthreads 32 -force
mrtransform mask_upsampled.mif -warp subject2template_warp.mif -interp nearest -datatype bit dwi_mask_in_template_space.mif -force
done

# find mask intersection
cd /home/Data/ALS/mrtrix_long2/
mrmath */dwi_mask_in_template_space.mif min template/mask_intersection.mif -datatype bit -force
fod2fixel -mask template/mask_intersection.mif -fmls_peak_value 0.13 template/wmfod_template.mif template/fixel_mask -force -peak fixel_peak.mif

# Calculate FD and FC
for ((i=0;i<${#arr1[@]};++i));
do
echo "------- Processing: ${arr1[i]} ---------"
cd /home/Data/ALS/mrtrix_long2/"${arr1[i]}"
#rm -r fixel_in_template_space_NOT_REORIENTED
mrtransform wmfod_norm.mif -warp subject2template_warp.mif -noreorientation fod_in_template_space_NOT_REORIENTED.mif -force
fod2fixel fod_in_template_space_NOT_REORIENTED.mif -mask ../template/mask_intersection.mif fixel_in_template_space_NOT_REORIENTED -afd fd.mif -force
#rm -r fixel_in_template_space
fixelreorient fixel_in_template_space_NOT_REORIENTED subject2template_warp.mif fixel_in_template_space -force
fixelcorrespondence fixel_in_template_space/fd.mif ../template/fixel_mask ../template/fd "${arr1[i]}".mif -force
warp2metric subject2template_warp.mif -fc ../template/fixel_mask ../template/fc "${arr1[i]}".mif -force
done

# Calculate logFC and FDC
cd /home/Data/ALS/mrtrix_long2/
mkdir template/log_fc
cp template/fc/index.mif template/fc/directions.mif template/log_fc
mkdir template/fdc
cp template/fc/index.mif template/fc/directions.mif template/fdc

for ((i=0;i<${#arr1[@]};++i));
do
echo "------- Processing: ${arr1[i]} ---------"
cd /home/Data/ALS/mrtrix_long2/"${arr1[i]}"
mrcalc ../template/fc/"${arr1[i]}".mif -log ../template/log_fc/"${arr1[i]}".mif
mrcalc ../template/fd/"${arr1[i]}".mif ../template/fc/"${arr1[i]}".mif -mult ../template/fdc/"${arr1[i]}".mif
done

# Tractography generation and filtering
cd /home/Data/ALS/mrtrix_long2/template
tckgen -angle 22.5 -maxlen 250 -minlen 10 -power 1.0 wmfod_template.mif -seed_image mask_intersection.mif -mask mask_intersection.mif -select 20000000 tracks_20_million.tck -force -nthreads 32 -cutoff 0.13
tcksift tracks_20_million.tck wmfod_template.mif tracks_2_million_sift.tck -term_number 2000000 -force -nthreads 32

#tckedit tracks_2_million_sift.tck tracks_pt2_million.tck -number 200k -force

# Fixel statistics
cd /home/Data/ALS/mrtrix_long2/template
fixelcfestats fd files_long.txt design_matrix_long.txt contrast_matrix_long.txt tracks_2_million_sift.tck stats_fd -nthreads 32 -negative
fixelcfestats log_fc files_long.txt design_matrix_long.txt contrast_matrix_long.txt tracks_2_million_sift.tck stats_log_fc -nthreads 32 -negative
fixelcfestats fdc files_long.txt design_matrix_long.txt contrast_matrix_long.txt tracks_2_million_sift.tck stats_fdc -nthreads 32 -negative

# Postprocessing
cd /home/Data/ALS/mrtrix_long2/template/log_fc
for ((i=0;i<${#arr1[@]};++i));
do
echo "------- Processing: ${arr1[i]} ---------"
fixel2voxel "${arr1[i]}".mif sum "${arr1[i]}".nii.gz
done

# Find voxels where p-value < 0.05
cd /home/Data/ALS/mrtrix_long2/template/stats_log_fc
fixel2voxel fwe_pvalue.mif max fwe_pvalue_vox.mif -force
mrthreshold -abs 0.95 fwe_pvalue_vox.mif fwe_pvalue_thr_bin.mif -force
mrconvert fwe_pvalue_thr_bin.mif fwe_pvalue_thr_bin.nii.gz -force

# Edit tractography and map fixel values at regions where statistically significant longitudinal change is noted, based on the input tractogram
cd /home/Data/ALS/mrtrix_long2/template
tckedit tracks_2_million_sift.tck -num 200000 tracks_200k_sift.tck
fixel2tsf stats_fd/fwe_pvalue.mif tracks_200k_sift.tck fd_fwe_pvalue.tsf
fixel2tsf stats_log_fc/fwe_pvalue.mif tracks_200k_sift.tck fc_fwe_pvalue.tsf
fixel2tsf stats_fdc/fwe_pvalue.mif tracks_200k_sift.tck fdc_fwe_pvalue.tsf
